/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.members.api;

import java.util.List;
import java.util.Map;

import com.adobe.cq.social.scf.SocialAuthorizable;
import com.adobe.cq.social.user.api.UserProfile;

public interface CommunityMemberUserProfile extends UserProfile {
    String RESOURCE_TYPE = "social/members/components/hbs/userprofile";

    /**
     * Get the groups witch user is member of.
     */
    SocialAuthorizable[] getMemberOfGroups();

    /**
     * Get the sites witch user is member of.
     * @return List of Map with the following properties: name, siteId, siteUrlName, url, sitePagePath, creator,
     *         userRoles
     */
    List<Map<String, String>> getMemberOfSites();

    /**
     * @return true if the user is disabled, false otherwise
     */
    boolean getDisabled();
}
