/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.members.api;

import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.OperationException;
import org.apache.sling.api.resource.Resource;

public interface MembersUtils {

    /**
     * Check if the current session has community administrator permission.
     */
    boolean isCommunityAdmin(final ResourceResolver resourceResolver) throws OperationException;

    /**
     * Get the {@link CommunityMemberGroup} for the specified user id with the specified resource type.
     */
    CommunityMemberGroup getCommunityGroup(final String id, final ResourceResolver resolver,
        final ClientUtilities clientUtils, final String resourceType);

    /**
     * Get the {@link CommunityMemberGroupProfile} for the specified user id with the specified resource type.
     */
    CommunityMemberGroupProfile getCommunityGroupProfile(final Resource resource, final ClientUtilities clientUtils,
        final String resourceType);

    /**
     * Checks if the member, represented as {@link CommunityMemberUserProfile} satisfies social-members repo
     * user/group policy.
     */
    boolean isValidMember(final CommunityMemberUserProfile userProfile);

    /**
     * Checks if the member, represented as {@link Authorizable} satisfies social-members repo user/group policy.
     */
    boolean isValidMember(final Authorizable authorizable) throws OperationException;

    /**
     * Checks if the member path satisfies social-members repo user/group policy.
     */
    boolean isValidMember(final String path, final boolean isGroup);

    /**
     * Checks if the member of group, represented as {@link Resource} satisfies social-members repo user/group policy.
     */
    boolean isValidGroupMember(final Resource authorizableResource);

    /**
     * @return the configured path of the user root node.
     */
    String getUserRootPath();

    /**
     * @return the configured path of the group root node.
     */
    String getGroupRootPath();
}
