/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.members.endpoints;

import javax.jcr.Session;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.jcr.api.SlingRepository;

import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialOperationResult;
import com.adobe.cq.social.scf.core.operations.AbstractSocialOperation;

@Component(metatype = false, componentAbstract = true)
public abstract class AbstractCommunityMemberGroupProfileOperation<T extends CommunityMemberGroupProfileOperations>
    extends AbstractSocialOperation {

    @Reference(cardinality = ReferenceCardinality.MANDATORY_UNARY, policy = ReferencePolicy.STATIC)
    private SlingRepository repository;

    /**
     * Gets session from resource {@link Session}.
     * @param resource the resource for which to retrieve the session
     * @return The <code>Session</code> or <code>null</code> if the session couldn't be created.
     */
    protected Session getSessionFromResource(final Resource resource) {
        return resource.getResourceResolver().adaptTo(Session.class);
    }

    @Override
    protected SocialOperationResult performOperation(final SlingHttpServletRequest request) throws OperationException {
        final Session session = getSessionFromResource(request.getResource());
        return performOperation(request, session);
    }

    /**
     * Perform the operation and send the response using the provided session.
     * @param request the client request.
     * @param session the session to be used to perform the operation
     * @return SocialOperationResult the result of the operation.
     * @throws OperationException if there is an error occurs while performing the operation.
     */
    protected abstract SocialOperationResult performOperation(final SlingHttpServletRequest request,
        final Session session) throws OperationException;

}
