/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.members.endpoints;

import java.util.List;

import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationExtension;
import com.adobe.cq.social.site.api.CommunitySite;

/**
 * Hook operation to enable clients register callback during an execution of an operation.
 */
public interface CommunityMemberGroupProfileOperationExtension extends OperationExtension<CommunitySite> {
    /**
     * Operation types.
     */
    enum MemberGroupOperation implements Operation {
        /** Create Operation. */
        CREATE,
        /** Add Member Operation. */
        ADD_MEMBER,
        /** Remove Member Operation. */
        REMOVE_MEMBER,
        /** Update Operation. */
        UPDATE
    };

    /**
     * Get the list of operations that this operation extension is interested in.
     * @return a list of {@link MemberGroupOperation}
     */
    @Override
    List<MemberGroupOperation> getOperationsToHookInto();
}
