/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.members.endpoints;

import java.util.Map;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.members.api.CommunityMemberGroup;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;

public interface CommunityMemberGroupProfileOperations extends Operation {
    // Request parameters name
    /** The prop group id. */
    String PROP_GROUP_ID = "groupId";

    /** The prop group name. */
    String PROP_GROUP_NAME = "givenName";

    /** The prop group description. */
    String PROP_GROUP_DESCRIPTION = "aboutMe";

    /** The prop member id. */
    String PROP_MEMBER_ID = "memberId";

    /**
     * Get the <code>SocialComponent</code> for the specified {@link Resource} and {@link SlingHttpServletRequest}.
     * @param group the target group resource
     * @param request the client request
     * @return the {@link SocialComponent}
     */
    SocialComponent getSocialComponentForGroup(final Resource group, final SlingHttpServletRequest request);

    /**
     * Create a new {@link CommunityMemberGroup} base on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the new {@link CommunityMemberGroup}
     * @throws OperationException if there is an error occurs
     */
    Resource create(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Add group representing by the specified resource.
     * @param resource the resource belonging to a tenant.
     * @param requestParams a map that contains the group id.
     */
    Resource createGroup(final Resource resource, final Map<String, Object> requestParams,
        final ClientUtilities clientUtils) throws OperationException;

    /**
     * Add member to {@link CommunityMemberGroup} base on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the {@link CommunityMemberGroup}
     * @throws OperationException if there is an error occurs
     */
    Resource addMember(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Add member to a group representing by the specified resource.
     * @param resource the resource belonging to a tenant.
     * @param requestParams a map that contains the group id and membersId.
     */
    Resource addMember(final Resource resource, final Map<String, Object> requestParams,
        final ClientUtilities clientUtils) throws OperationException;

    /**
     * Remove member from {@link CommunityMemberGroup} base on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the {@link CommunityMemberGroup}
     * @throws OperationException if there is an error occurs
     */
    Resource removeMember(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Remove member from a group representing by the specified resource.
     * @param resource the resource belonging to a tenant.
     * @param requestParams a map that contains the group id and membersId.
     */
    Resource removeMember(final Resource resource, final Map<String, Object> requestParams,
        final ClientUtilities clientUtils) throws OperationException;

    /**
     * Update {@link CommunityMemberGroup} base on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the {@link CommunityMemberGroup}
     * @throws OperationException if there is an error occurs
     */
    Resource update(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Update a group representing by the specified resource.
     * @param resource the resource.
     * @param requestParams a map that contains the groupId and membersId.
     */
    Resource update(final Resource resource, final Map<String, Object> requestParams,
        final ClientUtilities clientUtils) throws OperationException;
}
