/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.members.endpoints;

import java.util.List;

import com.adobe.cq.social.members.api.CommunityMemberUserProfile;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationExtension;

/**
 * Hook operation to enable clients register callback during an execution of an operation.
 */
public interface CommunityMemberUserProfileOperationExtension extends OperationExtension<CommunityMemberUserProfile> {
    /**
     * Operation types.
     */
    enum CommunityMemberUserProfileOperation implements Operation {
        /** Create operation. */
        CREATE,
        /** Change avatar operation. */
        CHANGE_AVATAR,
        /** Change password operation. */
        CHANGE_PASSWORD,
        /** Disable. */
        DISABLE,
        /** Enable. */
        ENABLE,
        /** Update operation. */
        UPDATE,
        /** Remove from group operation. */
        REMOVE_FROM_GROUP,
        /** Add to group operation. */
        ADD_TO_GROUP
    }

    /**
     * Get the list of operations that this operation extension is interested in.
     * @return a list of {@link CommunityMemberUserProfileOperation}
     */
    @Override
    List<CommunityMemberUserProfileOperation> getOperationsToHookInto();
}
