/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.members.endpoints;

import java.util.List;
import java.util.Map;

import javax.jcr.Session;

import com.adobe.cq.social.scf.SocialOperationResult;
import com.adobe.cq.social.user.internal.HttpToPublisher;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.members.api.CommunityMemberUser;
import com.adobe.cq.social.members.api.CommunityMemberUserProfile;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;

/**
 * Interface for CommunityMemberUserProfileOperations.
 */
public interface CommunityMemberUserProfileOperations {
    // Request parameters name
    /** The req prop email. */
    String REQ_PROP_EMAIL = "email";

    /** The req prop password. */
    String REQ_PROP_PASSWORD = "password";

    /** The req prop confirm password. */
    String REQ_PROP_CONFIRM_PASSWORD = "confirmPassword";

    /** The req prop user id. */
    String REQ_PROP_USER_ID = "userId";

    /** The req prop user first name. */
    String REQ_PROP_USER_FIRST_NAME = "givenName";

    /** The req prop user last name. */
    String REQ_PROP_USER_LAST_NAME = "familyName";

    /** The req prop user displayName. */
    String REQ_PROP_USER_DISPLAY_NAME = "displayName";

    /** The opt prop user gender. */
    String OPT_PROP_USER_GENDER = "gender";

    /** The opt prop user streetAddress. */
    String OPT_PROP_USER_ADDRESS = "streetAddress";

    /** The opt prop user city. */
    String OPT_PROP_USER_CITY = "city";

    /** The opt prop user region. */
    String OPT_PROP_USER_STATE = "region";

    /** The opt prop user aboutMe. */
    String OPT_PROP_USER_BIO = "aboutMe";

    /** The opt prop user language. */
    String OPT_PROP_USER_LANGUAGE = "language";

    /** The opt prop user jobTitle. */
    String OPT_PROP_USER_OCCUPATION = "jobTitle";

    /** The opt prop user phoneNumber. */
    String OPT_PROP_USER_PHONE_NUMBER = "phoneNumber";

    /** The opt prop user url. */
    String OPT_PROP_USER_URL = "url";

    /** The opt prop user groups. */
    String OPT_PROP_USER_GROUP_ID = "groupId";

    /** The opt prop user groups. */
    String OPT_PROP_USER_SITE_ID = "siteId";

    /** The path for the tunnel to use when verifying permission */
    String PERMS_PATH = "/home/users/community";

    /** The reference id for the user admin service user */
    String USER_ADMIN_SERVICE_ID = "communities-user-admin";

    /**
     * Get the <code>SocialComponent</code> for the specified {@link Resource} and {@link SlingHttpServletRequest}.
     * @param userProfile the target user profile
     * @param request the client request
     * @return the {@link SocialComponent}
     */
    SocialComponent getSocialComponentForUserProfile(final Resource userProfile, final SlingHttpServletRequest request);

    /**
     * Get the <code>SocialComponent</code> for the specified {@link Resource} and {@link SlingHttpServletRequest} and
     * for the specified resourceType.
     * @param userProfile the target user profile
     * @param request the client request
     * @return the {@link SocialComponent}
     */
    SocialComponent getSocialComponentForUserProfile(final Resource userProfile,
        final SlingHttpServletRequest request, final String resourceType);

    /**
     * Update a user profile on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource update(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Update the specified user profile with the specified {@link Map} of properties.
     * @param profileResource the target user profile
     * @param props a map of the properties to be updated
     * @param session the user session to be used to perform the operation
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource update(final Resource profileResource, final Map<String, Object> props, final Session session)
        throws OperationException;

    /**
     * Update a user profile on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource changeAvatar(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Update the specified user profile with the specified {@link Map} of properties.
     * @param profileResource the target user profile
     * @param props a map of the data source for avatar
     * @param session the user session to be used to perform the operation
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource changeAvatar(final Resource profileResource, final Map<String, Object> props, final Session session)
        throws OperationException;

    /**
     * Disable a user based on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource disable(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Enable a user based on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource enable(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Disable a user with the specified {@link Map} of properties.
     * @param profileResource the target user's profile
     * @param props a map of data with the disable reason
     * @param session the user session to be used to perform the operation
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource disable(final Resource profileResource, final Map<String, Object> props, final Session session)
        throws OperationException;

    /**
     * Re-enable a disabled user with the specified {@link Map} of properties.
     * @param profileResource the target user's profile
     * @param props a map that should probably be empty
     * @param session the user session to be used to perform the operation
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource enable(final Resource profileResource, final Map<String, Object> props, final Session session)
        throws OperationException;

    /**
     * Remove user from Groups based on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource removeUserFromGroups(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Remove user from Groups with the specified {@link Map} of properties.
     * @param profileResource the target user's profile
     * @param props a map that should contains array of groupId
     * @param session the user session to be used to perform the operation
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource removeUserFromGroups(final Resource profileResource, final Map<String, Object> props,
        final Session session) throws OperationException;

    /**
     * Add user to Groups based on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource addUserToGroups(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Add user to Groups with the specified {@link Map} of properties.
     * @param profileResource the target user's profile
     * @param props a map that should contains array of groupId
     * @param session the user session to be used to perform the operation
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource addUserToGroups(final Resource profileResource, final Map<String, Object> props, final Session session)
        throws OperationException;

    /**
     * Add user to sites, based on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource addUserToSites(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Remove user from sites, based on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the update {@link CommunityMemberUserProfile} resource
     * @throws OperationException if there is an error occurs
     */
    Resource removeUserFromSites(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Create a new {@link CommunityMemberUser} base on the specified {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return the new {@link CommunityMemberUser}
     * @throws OperationException if there is an error occurs
     */
    Resource create(final SlingHttpServletRequest request) throws OperationException;

    /**
     * Add user for a tenant representing by the specified resource.
     * @param resource the resource belonging to a tenant.
     * @param requestParams a map that contains the user id and user password.
     * @return the new {@link CommunityMemberUser}
     * @throws OperationException if there is an error occurs
     */
    Resource createUser(final Resource resource, final Map<String, Object> requestParams,
        final ClientUtilities clientUtils) throws OperationException;
}
