/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.api;

import java.util.Calendar;
import java.util.List;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

import org.apache.sling.api.adapter.Adaptable;

import com.day.cq.commons.jcr.JcrConstants;

/**
 * Message interface.
 * @deprecated @since AEM 6.1. Use {@link com.adobe.cq.social.messaging.client.api.MessageSocialComponent} instead.
 */
@Deprecated
public interface Message extends Adaptable {
    /**
     * property to specify message id.
     */
    String PN_MESSAGE_ID = "messageId_t";
    /**
     * property to specify recipients.
     */
    String PN_MESSAGE_RECIPIENTS = "Recipients_ts";
    /**
     * property to specify sender name.
     */
    String PN_MESSAGE_SENDER_NAME = "senderName_t";
    /**
     * property to specify recipients' names.
     */
    String PN_MESSAGE_RECIPIENT_NAMES = "recipientNames_ts";
    /**
     * property to specify message subject.
     */
    String PN_MESSAGE_SUBJECT = JcrConstants.JCR_TITLE;
    /**
     * property to specify message content.
     */
    String PN_MESSAGE_CONTENT = JcrConstants.JCR_DESCRIPTION;
    /**
     * property to specify sender id.
     */
    String PN_MESSAGE_SENDER = "sender_t";
    /**
     * property to specify to specify read or unread.
     */
    String PN_MESSAGE_READ = "read_b";
    /**
     * property to specify trashed or not.
     */
    String PN_MESSAGE_DELETED = "deleted_b";
    /**
     * property to specify time stamp of message.
     */
    String PN_MESSAGE_TIMESTAMP = "added";
    /**
     * node type for message Nodes.
     */
    String NT_MESSAGE_NODE_TYPE = "nt:unstructured";
    /**
     * property name for size of message.
     */
    String PN_MESSAGE_SIZE = "messageSize";

    /**
     * get message id.
     * @return id of message.
     */
    @CheckForNull
    String getId();

    /**
     * get id of sender.
     * @return sender id.
     */
    @CheckForNull
    String getSenderId();

    /**
     * get name of sender.
     * @return sender name
     */
    @CheckForNull
    String getSenderName();

    /**
     * get subject of message.
     * @return subject of message.
     */
    @CheckForNull
    String getSubject();

    /**
     * get content of message.
     * @return content of message.
     */
    @CheckForNull
    String getContent();

    /**
     * get list of ids of recipients.
     * @return list of ids of recipients
     */
    @Nonnull
    List<String> getRecipientIdList();

    /**
     * get list of recipient names.
     * @return list of recipient names.
     */
    @Nonnull
    List<String> getRecipientNameList();

    /**
     * get a custom property stored on message.
     * @param propertyName name of property to be searched for
     * @return value of a custom property
     */
    @CheckForNull
    Object getCustomProperty(String propertyName);

    /**
     * tells if message has been read.
     * @return true for read message.
     */
    boolean isRead();

    /**
     * tells if the message has been trashed.
     * @return true for trashed message.
     */
    boolean isDeleted();

    /**
     * time at which message had been sent.
     * @return message sending time.
     */
    @CheckForNull
    Calendar getTimestamp();

    /**
     * mark the message as trashed or un-trashed.
     * @param value true if the message is to be trashed, false otherwise.
     * @return true if existing value on message was different from passed value, false otherwise.
     */
    boolean setDeleted(boolean value);

    /**
     * mark the message as read or unread.
     * @param value true if the message is to be marked read, false otherwise.
     * @return true if existing value on message was different from passed value, false otherwise.
     */
    boolean setRead(boolean value);

    /**
     * change the value of an existing custom property on message.
     * @param name name of property
     * @param value value to be set
     * @return old value of the property if successful. <code>null</code> if the property is not an existing custom
     *         property of the message and hence could not be set.
     */
    @CheckForNull
    Object setCustomProperty(@Nonnull String name, @Nonnull Object value);
}
