/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.api;

import java.util.List;

/**
 * MessageBoxOverflowException is thrown if message box size limit would be exceeded on creating a message.
 */
public class MessageBoxOverflowException extends MessageSendException {
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new MessageBoxOverflowException with the specified message.
     * @param message The detailed message
     * @param undeliveredUsersList list of IDs of users/groups to whom message couldn't be delivered.
     */
    public MessageBoxOverflowException(final String message, final List<String> undeliveredUsersList) {
        super(message, undeliveredUsersList);
    }

    /**
     * Constructs a new MessageBoxOverflowException with the specified message and cause.
     * @param message The detailed message
     * @param cause The cause
     * @param undeliveredUsersList list of IDs of users/groups to whom message couldn't be delivered.
     */
    public MessageBoxOverflowException(final String message, final Throwable cause,
        final List<String> undeliveredUsersList) {
        super(message, cause, undeliveredUsersList);
    }

    /**
     * Constructs a new MessageBoxOverflowException with the specified cause.
     * @param cause The cause
     * @param undeliveredUsersList list of IDs of users/groups to whom message couldn't be delivered.
     */
    public MessageBoxOverflowException(final Throwable cause, final List<String> undeliveredUsersList) {
        super(cause, undeliveredUsersList);
    }
}
