/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.api;

import javax.annotation.Nonnull;

import org.osgi.service.cm.Configuration;

import com.adobe.cq.social.ugcbase.core.attachments.FileDataSource;

/**
 * Interface to build and send message .
 * @deprecated @since AEM 6.1 Use {@link com.adobe.cq.social.messaging.client.endpoints.MessagingOperationsService}
 *             .create instead.
 */
@Deprecated
public interface MessageBuilder {
    /**
     * inbox path {@link Configuration} property name.
     * @see #setConfiguration(org.osgi.service.cm.Configuration)
     */
    String PN_INBOX_PATH_CONFIGURATION = "inbox.path";
    /**
     * sent items path {@link Configuration} property name.
     * @see #setConfiguration(org.osgi.service.cm.Configuration)
     */
    String PN_SENT_ITEMS_PATH_CONFIGURATION = "sentitems.path";
    /**
     * sender id {@link Configuration} property name.
     * @see #setConfiguration(org.osgi.service.cm.Configuration)
     */
    String PN_SENDER_ID_CONFIGURATION = "SENDER_ID";

    /**
     * set the sender's id. This method would override {@link #PN_SENDER_ID_CONFIGURATION} configuration set using
     * {@link #setConfiguration(org.osgi.service.cm.Configuration)}
     * @param id the message sender's user id.
     * @return this instance for method chaining
     */
    @Nonnull
    MessageBuilder setSenderId(String id);

    /**
     * add a new message recipient.
     * @param id the message recipient user id.
     * @return this instance for method chaining.
     * @throws MessageException If an error occurs.
     */
    @Nonnull
    MessageBuilder addRecipient(String id) throws MessageException;

    /**
     * Set inbox path relative to recipients' node. This method would override {@link #PN_INBOX_PATH_CONFIGURATION}
     * configuration set using {@link #setConfiguration(org.osgi.service.cm.Configuration)}. Note that setting inbox
     * path is optional if sent items path has been specified. Such messages will be saved in sent items of the
     * sender, therefore either should be set.
     * @param inboxPath inbox path
     * @return this instance for method chaining
     */
    @Nonnull
    MessageBuilder setInboxPath(String inboxPath);

    /**
     * Set sent items path relative to sender's node. This method would override
     * {@link #PN_SENT_ITEMS_PATH_CONFIGURATION} configuration set using
     * {@link #setConfiguration(org.osgi.service.cm.Configuration)}. Note that setting sent items path is optional if
     * inbox path has been specified. Such messages will be sent to recipients but will not be saved in sent items of
     * the sender.
     * @param sentItemsPath sent items path
     * @return this instance for method chaining
     */
    @Nonnull
    MessageBuilder setSentItemsPath(String sentItemsPath);

    /**
     * Pass messaging configurations. It can be used to set:
     * <ol>
     * <li>inbox path relative to recipients' node: this can be set by using {@link #PN_INBOX_PATH_CONFIGURATION} as
     * property name in the passed configuration</li>
     * <li>sent items path relative to sender's node: this can be set by using
     * {@link #PN_SENT_ITEMS_PATH_CONFIGURATION} as property name in the passed configuration</li>
     * <li>sender id: this can be set by using {@link #PN_SENDER_ID_CONFIGURATION} as property name in the passed
     * configuration</li>
     * <li>custom properties of messages</li>
     * </ol>
     * The values specified here can be overridden by respective setters namely -
     * <ol>
     * <li>{@link #setInboxPath(String)}</li>
     * <li>{@link #setSentItemsPath(String)}</li>
     * <li>{@link #setSenderId(String)}</li>
     * <li>{@link #addCustomProperty(String, Object)}</li>
     * </ol>
     * Example:
     *
     * <pre>
     * {@code     Configuration config;
     *       MessageBuilder builder1;
     *       MessageBuilder builder2;
     *       ...
     *       //assuming config contains inbox path as "/a/b"
     *       builder1.setInboxPath("/c/d");
     *       builder1.setConfiguration(config);
     *       builder2.setConfiguration(config);
     *       //builder1 has inbox path as "/c/d" and builder2 has inbox path as "/a/b"
     * }
     * </pre>
     * @param configuration {@link Configuration} Properties dictionary.
     * @return this instance for method chaining
     * @see #setInboxPath(String)
     */
    @Nonnull
    MessageBuilder setConfiguration(@Nonnull Configuration configuration);

    /**
     * to add custom properties to message. This method would override the configuration set using
     * {@link #setConfiguration(org.osgi.service.cm.Configuration)}
     * @param property property to be added
     * @param value value of property
     * @return this instance for method chaining
     */
    @Nonnull
    MessageBuilder addCustomProperty(@Nonnull String property, @Nonnull Object value);

    /**
     * to add custom properties to message.
     * @param attachment attachment to be added
     * @return this instance for method chaining
     */
    @Nonnull
    MessageBuilder addAttachment(FileDataSource attachment);

    /**
     * send the message.
     * @throws MessageException in case of failure.
     */
    void build() throws MessageException;
}
