/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.api;

/**
 * MessageException is the generic exception for all exceptions in message api.
 */
public class MessageException extends Exception {
    private static final long serialVersionUID = 1L;

    /**
     * Constructs a new MessageException with the specified message.
     * @param message The detailed message
     */
    public MessageException(final String message) {
        super(message);
    }

    /**
     * Constructs a new MessageException with the specified message and cause.
     * @param message The detailed message
     * @param cause The cause
     */
    public MessageException(final String message, final Throwable cause) {
        super(message, cause);
    }

    /**
     * Constructs a new MessageException with the specified cause.
     * @param cause The cause
     */
    public MessageException(final Throwable cause) {
        super(cause);
    }
}
