/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.api;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * Provides methods for retrieving messages.
 * @deprecated @since AEM 6.1
 */
@Deprecated
public interface MessageSearch {
    /**
     * search for messages rooted at root and matching property values as per the passed property map(conjunction).
     * @param root resource under which messages are to be searched for.
     * @param propertyMap map containing message properties and values
     * @param first lower limit (inclusive) of the message range to be fetched
     * @param last upper limit (inclusive) of the message range to be fetched
     * @return {@link Message}s satisfying all the properties criteria or <code>null</code> if root passed is
     *         <code>null</code>
     */
    @CheckForNull
    Iterator<Message> search(Resource root, Map<String, Object> propertyMap, int first, int last);

    /**
     * get the {@link Message} having the given id.
     * @param root parent resource like inbox or sent items
     * @param messageId message id of message to be searched for.
     * @return {@link Message} having the specified id.
     */
    @CheckForNull
    Message get(@Nonnull Resource root, @Nonnull String messageId);

    /**
     * get all the message boxes present under the passed resource.
     * @param root resource under which message boxes are to be searched.
     * @return list of message boxes resources.
     */
    @Nonnull
    List<Resource> getMessageBoxes(@Nonnull Resource root);

    /**
     * get all the message boxes present under the passed parent path.
     * @param rootPath path under which message boxes are to be searched.
     * @param resolver the resolver to use to get the message boxes.
     * @return list of message boxes resources.
     */
    @Nonnull
    List<Resource> getMessageBoxes(@Nonnull ResourceResolver resolver, @Nonnull String rootPath);

    /**
     * Searches for {@link Message} satisfying the passed {@link MessageFilter} criteria.
     * @param resolver {@link ResourceResolver} to search with.
     * @param filter {@link MessageFilter} filtering criteria.
     * @param first lower limit (inclusive) of the message range to be fetched
     * @param last upper limit (inclusive) of the message range to be fetched
     * @return Search result.
     * @throws RepositoryException Exception while searching.
     */
    @Nonnull
    Iterable<Message> search(@Nonnull final ResourceResolver resolver, @Nonnull final MessageFilter filter,
        final int first, final int last) throws RepositoryException;
}
