/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.api;

import java.util.List;

import javax.annotation.CheckForNull;

/**
 * MessageSendException is a generic exception for all exceptions during message sending.
 */
public class MessageSendException extends MessageException {
    private static final long serialVersionUID = 1L;
    /**
     * list of IDs of users/groups to whom message couldn't be delivered.
     */
    private final List<String> undeliveredUsersList;

    /**
     * Constructs a new MessageSendException with the specified message.
     * @param message The detailed message
     * @param undeliveredUsersList list of IDs of users/groups to whom message couldn't be delivered.
     */
    public MessageSendException(final String message, final List<String> undeliveredUsersList) {
        super(message);
        this.undeliveredUsersList = undeliveredUsersList;
    }

    /**
     * Constructs a new MessageSendException with the specified message.
     * @param message The detailed message
     * @param undeliveredUsersList list of IDs of users/groups to whom message couldn't be delivered.
     * @param cause The cause
     */
    public MessageSendException(final String message, final List<String> undeliveredUsersList, final Throwable cause) {
        super(message, cause);
        this.undeliveredUsersList = undeliveredUsersList;
    }

    /**
     * Constructs a new MessageSendException with the specified message and cause.
     * @param message The detailed message
     * @param undeliveredUsersList list of IDs of users/groups to whom message couldn't be delivered.
     * @param cause The cause
     */
    public MessageSendException(final String message, final Throwable cause, final List<String> undeliveredUsersList) {
        super(message, cause);
        this.undeliveredUsersList = undeliveredUsersList;
    }

    /**
     * Constructs a new MessageSendException with the specified cause.
     * @param undeliveredUsersList list of IDs of users/groups to whom message couldn't be delivered.
     * @param cause The cause
     */
    public MessageSendException(final Throwable cause, final List<String> undeliveredUsersList) {
        super(cause);
        this.undeliveredUsersList = undeliveredUsersList;
    }

    /**
     * get list of IDs of users/groups to whom message couldn't be delivered.
     * @return list of IDs of users/groups
     */
    @CheckForNull
    public List<String> getUndeliveredUsersList() {
        return undeliveredUsersList;
    }
}
