/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.api;

import java.util.List;

import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

/**
 * Messaging service exposed for sending messages. Also extends {@link MessageSearch} for retrieving messages.
 * @deprecated @since AEM 6.1
 */
@Deprecated
public interface MessagingService extends MessageSearch {

    /** Custom properties Names whitelist service property name. */
    String MESSAGE_CUSTOM_PROPERTIES_WHITE_LIST = "message.properties";

    /**
     * return a new {@link MessageBuilder}.
     * @param senderId user id of the sender.
     * @param asiPath the asiPath to be prefixed to the message resource path
     * @param isFiltered if true, the white list filtering is applied
     * @return a new message sender.
     */
    @Nonnull
    MessageBuilder newMessageSender(@Nonnull String senderId, @Nonnull String asiPath, final boolean isFiltered);

    /**
     * mark all the messages in message list as read or unread.
     * @param messageList list of {@link Message}s
     * @param value true if the message is to be marked read, false otherwise.
     * @param resourceResolver {@link ResourceResolver}
     * @throws PersistenceException in case of failure on session save.
     * @deprecated Use {@link com.adobe.cq.social.messaging.client.endpoints.MessagingOperationsService} instead.
     */
    @Deprecated
    void setRead(@Nonnull List<Message> messageList, boolean value, @Nonnull ResourceResolver resourceResolver)
        throws PersistenceException;

    /**
     * mark all the messages in message list as trashed or un-trashed.
     * @param messageList list of {@link Message}s
     * @param value true if the message is to be marked trashed, false otherwise.
     * @param resourceResolver {@link ResourceResolver}
     * @throws PersistenceException in case of failure on session save.
     * @deprecated Use {@link com.adobe.cq.social.messaging.client.endpoints.MessagingOperationsService} instead.
     */
    @Deprecated
    void setDeleted(@Nonnull List<Message> messageList, boolean value, @Nonnull ResourceResolver resourceResolver)
        throws PersistenceException;

    /**
     * change the value of an existing custom property on all messages in message list.
     * @param messageList list of {@link Message}s
     * @param name name of property to be set
     * @param value value to be set
     * @param resourceResolver {@link ResourceResolver}
     * @throws PersistenceException in case of failure on session save.
     * @deprecated Use {@link com.adobe.cq.social.messaging.client.endpoints.MessagingOperationsService} instead.
     */
    @Deprecated
    void setCustomProperty(@Nonnull List<Message> messageList, @Nonnull String name, @Nonnull Object value,
        @Nonnull ResourceResolver resourceResolver) throws PersistenceException;

    /**
     * permanently delete all the messages in message list.
     * @param messageResourceList list of Message {@link Resource}
     * @param resourceResolver {@link ResourceResolver}
     * @throws PersistenceException in case of failure on session save.
     * @deprecated Use {@link com.adobe.cq.social.messaging.client.endpoints.MessagingOperationsService} instead.
     */
    @Deprecated
    void delete(@Nonnull List<Resource> messageResourceList, @Nonnull ResourceResolver resourceResolver)
        throws PersistenceException;

    /**
     * get the usage statistics of the user corresponding to the passed resolver.
     * @param resource The message box resource.
     * @return {@link Usage}
     * @throws RepositoryException {@link RepositoryException} if some exception occurs in calculating the statistics.
     */
    @Nonnull
    Usage getUserStatistics(@Nonnull Resource resource) throws RepositoryException;

    /**
     * Return a list of message fields that have been whitelisted.
     * @return List of field names that are on the whitelist.
     */
    @Nonnull
    List<String> getWhiteList();
}
