/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.api;

import com.adobe.cq.social.messaging.client.api.MessageCounts;

/**
 * Provides information about the usage statistics of the space provided for messaging.
 */
public interface Usage {
    /**
     * get the current count of messages.
     * @param countType {@link MessageCounts.CountType} type of count needed
     * @return current count of messages.
     */
    long getCount(MessageCounts.CountType countType);

    /**
     * get the upper limit on total number of messages.
     * @return upper limit on number of messages.
     */
    long getMaxCount();

    /**
     * get the current space used by all the messages.
     * @return current size of the messages in bytes.
     */
    long getSize();

    /**
     * get the upper limit on the total space used by all the messages.
     * @return upper limit on size in bytes.
     */
    long getMaxSize();
}
