/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.client.api;

import javax.annotation.Nonnull;

/**
 * Represents a single message attachment.
 */
public interface Attachment {
    /**
     * @return display name of the message attachment.
     */
    @Nonnull
    String getName();

    /**
     * @return JCR Repository path of the attachment data.
     */
    @Nonnull
    String getPath();

    /**
     * @return externalized link to the attachment.
     */
    @Nonnull
    String getExternalLink();
}
