/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.client.api;

import java.util.Set;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;

import com.adobe.cq.social.scf.SocialComponent;

/**
 * Compose message as social component.
 */
public interface ComposeMessageSocialComponent extends SocialComponent {
    /**
     * @return true if the component has been opened in forward mode.
     */
    boolean isToBeForwarded();

    /**
     * @return true if the component has been opened in reply all mode.
     */
    boolean isReplyAll();

    /**
     * Information about logged in user.
     * @return {@link com.adobe.cq.social.messaging.client.api.MessagingUser}
     * @throws javax.jcr.RepositoryException {@link javax.jcr.RepositoryException}
     */
    @CheckForNull
    MessagingUser getLoggedInUser() throws RepositoryException;

    /**
     * @return message which is being forwarded/replied.
     * @throws RepositoryException {@link RepositoryException}
     */
    @CheckForNull
    MessageSocialComponent getMessage() throws RepositoryException;

    /**
     * @return get form id of the containing form.
     */
    @CheckForNull
    String getFormID();

    /**
     * @return {@link FormData} of the containing form.
     * @throws RepositoryException {@link RepositoryException}
     */
    @Nonnull
    Set<FormData> getFormData() throws RepositoryException;

}
