/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.client.api;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.LoginException;

import com.adobe.cq.social.commons.comments.api.PageInfo;
import com.adobe.cq.social.messaging.api.Usage;
import com.adobe.cq.social.scf.SocialCollectionComponent;

/**
 * Represents a Messaging MessageBox.
 */
public interface MessageBoxSocialComponent extends SocialCollectionComponent {
    /** property to customize folders to look up the messages in for this message box. **/
    String PN_FOLDER_PATHS = "folderPaths";

    /**
     * The resource type value for a MessageBoxSocialComponent.
     */
    String RESOURCE_TYPE = "social/messaging/components/hbs/messagebox";

    /**
     * The node type for message box nodes.
     */
    // is this still needed for JSRP? If not remove it.
    String NODE_TYPE = "sling:Folder";

    /**
     * Name of the property that stores the message box size.
     */
    String PN_SIZE = "messageBoxSize";

    /**
     * @return {@link PageInfo}
     */
    @Nonnull
    PageInfo getPageInfo();

    /**
     * @return paths under which this message box will search for messages.
     */
    @Nonnull
    List<String> getFolderPaths();

    /**
     * @return A Map of aggregated message counts for any mailbox located beneath the path of this message box.
     */
    @Nonnull
    Map<String, Long> getMessageCounts();

    /**
     * get the usage statistics of the user.
     * @return {@link com.adobe.cq.social.messaging.api.Usage}
     * @throws javax.jcr.RepositoryException {@link javax.jcr.RepositoryException} if some exception occurs in
     *             calculating the statistics.
     * @throws org.apache.sling.api.resource.LoginException {@link org.apache.sling.api.resource.LoginException}
     */
    @Nonnull
    Usage getUserStatistics() throws RepositoryException, LoginException;

    /**
     * Queries the value of the specified count type for this message box.
     * @param countType The type of count to return. See {@link MessageCounts.CountType}
     * @return The value of the specified count type.
     */
    long getCount(final MessageCounts.CountType countType);

    /**
     * Get the size of the message box in bytes.
     * @return The size of the message box in bytes.
     */
    long getSize();
}
