/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.client.api;

import java.util.Calendar;
import java.util.List;
import java.util.Map;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

import com.adobe.cq.social.messaging.api.MessageException;
import com.adobe.cq.social.scf.SocialComponent;
import com.day.cq.commons.jcr.JcrConstants;

/**
 * Represents a single Social Messaging message.
 */
public interface MessageSocialComponent extends SocialComponent {

    /**
     * Resource type for message.
     */
    String MESSAGE_RESOURCE_TYPE = "social/messaging/components/hbs/message";
    /**
     * property to specify message id.
     */
    String PN_MESSAGE_ID = "messageId_t";
    /**
     * property to specify recipients.
     */
    String PN_MESSAGE_RECIPIENTS = "Recipients_ts";
    /**
     * property to specify sender name.
     */
    String PN_MESSAGE_SENDER_NAME = "senderName_t";
    /**
     * property to specify recipients' names.
     */
    String PN_MESSAGE_RECIPIENT_NAMES = "recipientNames_ts";
    /**
     * property to specify message subject.
     */
    String PN_MESSAGE_SUBJECT = JcrConstants.JCR_TITLE;
    /**
     * property to specify message content.
     */
    String PN_MESSAGE_CONTENT = JcrConstants.JCR_DESCRIPTION;
    /**
     * property to specify sender id.
     */
    String PN_MESSAGE_SENDER = "sender_t";
    /**
     * property to specify to specify read or unread.
     */
    String PN_MESSAGE_READ = "read_b";
    /**
     * property to specify trashed or not.
     */
    String PN_MESSAGE_DELETED = "deleted_b";
    /**
     * property to specify time stamp of message.
     */
    String PN_MESSAGE_TIMESTAMP = "added";
    /**
     * property name for size of message.
     */
    String PN_MESSAGE_SIZE = "messageSize";

    /**
     * @return custom properties.
     */
    @CheckForNull
    Map<String, Object> getCustomProperties();

    /**
     * @return message subject.
     */
    @Nonnull
    String getSubject();

    /**
     * @return message content.
     */
    @Nonnull
    String getContent();

    /**
     * @return message's timestamp.
     */
    @CheckForNull
    Calendar getTimestamp();

    /**
     * Get the relative path of this message's message box from the user's node.
     * @return relative path of this message's message box to user's node.
     */
    @CheckForNull
    String getMessageBoxRelativePath();

    /**
     * Get message attachments.
     * @return {@link Attachment}s.
     * @throws MessageException {@link MessageException} if there is error fetching attachments.
     */
    @Nonnull
    List<Attachment> getAttachments() throws MessageException;

    /**
     * Get message sender.
     * @return {@link MessagingUser}.
     */
    @CheckForNull
    MessagingUser getSender();

    /**
     * Get recipients of a message.
     * @return list of {@link MessagingUser}.
     */
    @Nonnull
    List<MessagingUser> getRecipients();

    /**
     * Get the names of the recipients of a message
     * @return list of the recipient's names
     */
    @Nonnull
    List<String> getRecipientsNames();

    /**
     * @return true if message is read, false otherwise.
     */
    @Nonnull
    boolean isRead();

    /**
     * @return true if the message has been deleted (move to trash), false otherwise.
     */
    @Nonnull
    boolean isDeleted();

    /**
     * @return message id.
     */
    @CheckForNull
    String getMessageID();

    /**
     * @return absolute path of this message's message box.
     */
    @CheckForNull
    String getMessageBoxPath();
}
