/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.client.api;

import javax.annotation.Nonnull;

import com.adobe.cq.social.scf.User;

/**
 * This represents messaging user.
 */
public interface MessagingUser extends User {
    /**
     * Path prefix for messaging user resources.
     */
    String PATH_PREFIX = "social/messaging/";

    /**
     * Messaging user resource type value.
     */
    String RESOURCE_TYPE = PATH_PREFIX + "user";

    /**
     * Constant for User types.
     */
    String USER_TYPE = "user";

    /**
     * Constant for Group types.
     */
    String GROUP_TYPE = "group";

    /**
     * @return {@link #USER_TYPE} if this is user {@link #GROUP_TYPE} if this is group.
     */
    @Nonnull
    String getType();
}
