/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.messaging.client.endpoints;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.jcr.Session;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.ugcbase.core.attachments.FileDataSource;

/**
 * CRUD Operation of a {@link com.adobe.cq.social.messaging.api.Message}.
 */
public interface MessagingOperationsService {
    /**
     * Creates a new message from/based on {@link SlingHttpServletRequest}.
     * @param request the client request
     * @return Http response status code.
     * @throws com.adobe.cq.social.scf.OperationException if there is an error occurs
     */
    short create(@Nonnull final SlingHttpServletRequest request) throws OperationException;

    /**
     * Create a a new message with the specified {@link java.util.Map} of properties and {@link java.util.List} of
     * attachments.
     * @param resolver the root resource of the message to be created.
     * @param resource the resource that triggered the message creation.
     * @param senderAuthId Authorizable Id of the message sender.
     * @param props message properties passed as a java map.
     * @param attachments List of {@link com.adobe.cq.social.ugcbase.core.attachments.FileDataSource} of the message
     *            attachments.
     * @param clientUtils A {@link ClientUtilities} object.
     * @return the new {@link com.adobe.cq.social.messaging.api.Message}
     * @throws com.adobe.cq.social.scf.OperationException if there is an error occurs
     */
    short create(@Nonnull final ResourceResolver resolver, @Nonnull final Resource resource,
        @Nonnull final String senderAuthId, @Nonnull final Map<String, Object> props,
        @Nonnull final List<FileDataSource> attachments, final ClientUtilities clientUtils) throws OperationException;

    /**
     * Update a message based on the specified {@link org.apache.sling.api.SlingHttpServletRequest}.
     * @param request The {@link org.apache.sling.api.SlingHttpServletRequest}.
     * @return the update message.
     * @throws com.adobe.cq.social.scf.OperationException if there is an error occurs
     */
    @Nonnull
    Resource update(@Nonnull final SlingHttpServletRequest request) throws OperationException;

    /**
     * Update the specified message with the specified {@link java.util.Map} of properties and {@link java.util.List}
     * of attachments.
     * @param commentResource the target message resource.
     * @param props a map of the properties to be updated
     * @param attachments a list of attachment to be added to the specified message.
     * @return the new updated message resource.
     * @throws com.adobe.cq.social.scf.OperationException if there is an error occurs
     */
    @Nonnull
    Resource update(@Nonnull final Resource commentResource, @Nonnull final Map<String, Object> props,
        final List<FileDataSource> attachments) throws OperationException;

    /**
     * Delete a {@link com.adobe.cq.social.messaging.api.Message} specified by the
     * {@link org.apache.sling.api.SlingHttpServletRequest} using the specified {@link javax.jcr.Session}.
     * @param request the http request which specifies the target message.
     * @param session {@link javax.jcr.Session}
     * @throws com.adobe.cq.social.scf.OperationException if there is an error occurs
     */
    @Nonnull
    void delete(@Nonnull final SlingHttpServletRequest request, @Nonnull final Session session)
        throws OperationException;

    /**
     * Delete a message represented by the specified {@link org.apache.sling.api.resource.Resource}.
     * @param messageResource The {@link org.apache.sling.api.resource.Resource} that is the message to be deleted.
     * @param session {@link javax.jcr.Session}
     * @throws com.adobe.cq.social.scf.OperationException if there is an error occurs
     */
    @Nonnull
    void delete(@Nonnull final Resource messageResource, @Nonnull final Session session) throws OperationException;
}
