/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.moderation.dashboard.api;

import java.util.List;

import com.adobe.cq.social.scf.SocialComponent;

/**
 * A FilterGroup actually contains several groups of filters for searching in the moderation dashboard. Each group
 * within is treated as a logical AND with the other groups, but within each group the selected filters are ORed
 * together for the search.
 * @author mnew
 */
public interface FilterGroup extends SocialComponent {

    /** ResourceType for this component. */
    String RESOURCE_TYPE = "social/moderation/filters";

    /**
     * Inner class for providing access to the resourceType names.
     * @return a ResourceTypeFilters object
     */
    ResourceTypeFilters getResourceTypeFilters();

    /** Inner class for providing access to the resourceType names. */
    public interface ResourceTypeFilters {

        /**
         * @return names the names of the filters for resourceTypes.
         */
        List<String> getNames();
    }

    /**
     * Return a list of sites the current user can moderate.
     * @return a List of site names.
     */
    List<String> getSites();

    /**
     * Return whether or not any sites are visible to the current user.
     * @return true if there is at least one site visible, false otherwise.
     */
    boolean getHasSites();

    /**
     * Return whether or not more than one site is visible to the current user.
     * @return true if there are two or more sites visible, false otherwise.
     */
    boolean getHasMultipleSites();
}