/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.moderation.dashboard.api;

import com.adobe.cq.social.scf.SocialCollectionComponent;

public interface ModerationDashboard extends SocialCollectionComponent {

    /** This resourceType. */
    String RESOURCE_TYPE = "social/moderation/dashboard";

    /** Default prefix path to UGC if no other is specified. */
    String DEFAULT_UGC_PREFIX = "/content/usergenerated";

    /** Default path to UGC if no other is specified. */
    String DEFAULT_UGC_PATH = DEFAULT_UGC_PREFIX + "/content";

    String DEFAULT_SEARCH_PATH = "/content";

    /** Used to read sites filter info from request. */
    String FILTER_SITES = "social:sites";

    /** Used to read content status filter info from request. */
    String FILTER_STATUS = "social:status";

    /** Used to read content state filter info from request. */
    String FILTER_FLAGGING = "social:flagging";

    /** Used to read contentType filter info from request. */
    String FILTER_CONTENT_TYPE = "social:contentType";

    /** Used to read search text filter info from request. */
    String FILTER_SEARCH_TEXT = "social:searchText";

    /** Used to read search options from request. */
    String FILTER_SEARCH_OPTIONS = "social:searchOptions";

    /** Used to read user search values from request. */
    String FILTER_USER_SEARCH = "social:userSearch";

    /** Used in date search. */
    String FILTER_DATE_MIN = "mindate";

    /** Used in date search. */
    String FILTER_DATE_MAX = "maxdate";

    /** Used in sentiment search. */
    String FILTER_SENTIMENT = "social:sentiment";

    /** Used in user searches. */
    String SEARCH_USER_ID = "userIdentifier";

    /** Page size if no other is specified. */
    int DEFAULT_PAGE_SIZE = 30;

    /**
     * @return true if there are more ugc that matches the query, false if all ugc has been returned
     */
    boolean getHasNext();
}
