/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.moderation.dashboard.api;

import java.util.List;
import java.util.Map;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.moderation.dashboard.impl.ModerationDashboardImpl;
import com.adobe.cq.social.moderation.dashboard.impl.ModerationDashboardQueryInfo;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.scf.core.BaseQueryRequestInfo;

@Component(metatype = true, label = "AEM Communities Moderation Dashboard",
        description = "This component provides a dashboard for moderators to use.", immediate = true)
@Service
public class ModerationDashboardSocialComponentFactory extends AbstractSocialComponentFactory {

    /** Factory Manager. */
    @Reference
    private SocialComponentFactoryManager scfm;

    /**
     * Return the socialComponent.
     * @param resource The resource for the social component.
     * @return the social component this factory provides.
     */
    public SocialComponent getSocialComponent(final Resource resource) {
        return new ModerationDashboardImpl(resource, getClientUtilities(resource.getResourceResolver()),
            getResourceTypeFilters());
    }

    /**
     * Return the socialComponent.
     * @param resource The resource for the social component.
     * @param request The request using this factory to get a social component.
     * @return the social component this factory provides.
     */
    public SocialComponent getSocialComponent(final Resource resource, final SlingHttpServletRequest request) {
        return new ModerationDashboardImpl(resource, getClientUtilities(request), getQueryRequestInfo(request),
            getResourceTypeFilters());
    }

    /**
     * Return the socialComponent.
     * @param resource The resource for the social component.
     * @param clientUtils ClientUtils used
     * @param queryRequestInfo the queryRequestInfo, which might be used.
     * @return the social component this factory provides.
     */
    public SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtils,
        final QueryRequestInfo queryRequestInfo) {
        return new ModerationDashboardImpl(resource, clientUtils, queryRequestInfo, getResourceTypeFilters());
    }

    /**
     * Get a Map of resourceType filters from the FilterGroupSocialComponentFactory.
     * @return a Map of filter names and values, the values each being a list of resourceTypes.
     */
    private Map<String, List<String>> getResourceTypeFilters() {
        FilterGroupSocialComponentFactory filterGroupFactory =
            (FilterGroupSocialComponentFactory) scfm.getSocialComponentFactory(FilterGroup.RESOURCE_TYPE);
        return filterGroupFactory.getResourceTypeFilters();
    }

    @Override
    public String getSupportedResourceType() {
        return ModerationDashboard.RESOURCE_TYPE;
    }

    @Override
    protected QueryRequestInfo getQueryRequestInfo(final SlingHttpServletRequest request) {
        if (request != null) {
            return new ModerationDashboardQueryInfo(request);
        } else {
            return BaseQueryRequestInfo.DEFAULT_QUERY_REQUEST;
        }
    }
}
