/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.moderation.dashboard.api;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.cq.social.moderation.dashboard.impl.UserDetailsImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.user.api.UserProfile;
import com.adobe.cq.social.user.api.UserProfileComponentFactory;

@Component(metatype = true, label = "AEM Communities User Details",
        description = "This component provides the details and activity stream of a given user.", immediate = true)
@Service
public class UserDetailsSocialComponentFactory extends UserProfileComponentFactory {

    @Override
    public SocialComponent getSocialComponent(final Resource resource) {
        final ResourceResolver resolver = resource.getResourceResolver();
        final ClientUtilities clientUtils = getClientUtilities(resolver);
        final Resource userResource = getUserResource(resolver, clientUtils);
        final UserProfile profile = (UserProfile) super.getSocialComponent(userResource);
        return new UserDetailsImpl(userResource, clientUtils, profile);
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final SlingHttpServletRequest request) {
        final ResourceResolver resolver = resource.getResourceResolver();
        ClientUtilities clientUtils = getClientUtilities(request);
        Resource userResource = getUserResource(resolver, clientUtils);
        final UserProfile profile = (UserProfile) super.getSocialComponent(userResource, request);
        return new UserDetailsImpl(userResource, clientUtils, profile);
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtils,
        final QueryRequestInfo requestInfo) {
        final ResourceResolver resolver = resource.getResourceResolver();
        Resource userResource = getUserResource(resolver, clientUtils);
        final UserProfile profile = (UserProfile) super.getSocialComponent(userResource, clientUtils, requestInfo);
        return new UserDetailsImpl(userResource, clientUtils, profile);
    }

    @Override
    public String getSupportedResourceType() {
        return UserDetails.RESOURCE_TYPE;
    }

    private Resource getUserResource(final ResourceResolver resolver, final ClientUtilities clientUtils) {
        SlingHttpServletRequest request = clientUtils.getRequest();
        String userID = request.getRequestPathInfo().getSuffix();
        if (userID == null) {
            // return the current session user
            userID = clientUtils.getAuthorizedUserId();
        }
        return clientUtils.getUser(userID, resolver).getResource();
    }

}
