/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.notifications.api;

public class NotificationConstants {
    private NotificationConstants() {
    }

    public static final String NOTIFICATION_EVENTS_PREFIX = "com/adobe/cq/social/notifications";
    /**
     * The topic for the OSGi event which is sent when a social activity has been added to a stream.
     */
    public static final String TOPIC_SOCIAL_NOTIFICATIONS_ACTIVITY_ADDED = NOTIFICATION_EVENTS_PREFIX + "/notify";
    /**
     * Event property names that is included as part of the {@link TOPIC_SOCIAL_NOTIFICATIONS_ACTIVITY_ADDED} event.
     */
    public static final String EVENT_CHANNELS_PROP = "com/adobe/cq/social/notifications/channels";
    public static final String TARGET_ID_PROP = "com/adobe/cq/social/notifications/targetId";
    public static final String VERB_PROP = "com/adobe/cq/social/notifications/verb";
    public static final String NOTIFICATION_PATH_PROP = "com/adobe/cq/social/notifications/path";
    public static final String USER_ID_PROP = "com/adobe/cq/social/notifications/userid";

    /**
     * Subscription path
     */
    public static final String PREFERENCES_ROOT_PATH = "community/preferences/subscriptions";

    /**
     * Activity Extension Properties
     */
    public static final String NOTIFICATION_STATUS_PROP = "status_s";
    public static final String NOTIFICATION_CHANNELS_PROP = "channel_ss";
}
