/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.notifications.api;

import javax.jcr.RepositoryException;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;

import com.adobe.cq.social.ugc.api.Constraint;
import com.adobe.cq.social.ugc.api.UgcFilter;
import com.adobe.granite.activitystreams.ActivityException;
import com.adobe.granite.activitystreams.ActivityStream;

public interface NotificationManager {
    /**
     * Check if the stream exist for the owner of the specified resource resolver
     */
    boolean isStreamExist(final ResourceResolver resolver);

    /**
     * Get the notification stream for the specified userId. If the stream does not exist and the create flag is set
     * to true, the method create a notification stream; otherwise, it throws <code>ActivityStreamExeption</code>.
     * @param adminResolver admin resolver
     * @param userId the target user id
     * @param create If the stream does not exist and the create flag is set to true, the method create a notification
     *            stream; otherwise, it throws <code>ActivityExeption</code>.
     * @return
     */
    ActivityStream getNotificationStream(final ResourceResolver adminResolver, final String userId,
        final boolean create) throws ActivityException;

    /**
     * Get notifications starting at the specified startIndex.
     * @param resolver owner resolver
     * @param startIndex
     * @param size
     * @return
     */
    Iterable<Notification> getNotifications(final ResourceResolver resolver, final UgcFilter filter,
        final int startIndex, final int size);

    /**
     * TODO: We probably want to move this API into ActivityStream Get the number of unread notification for the
     * specified user and channel
     * @param resolver owner resolver
     * @param channelId
     * @return
     * @throws RepositoryException
     */
    long getUnreadCount(ResourceResolver resolver, Constraint customConstraint, String channelId)
        throws RepositoryException;

    Iterable<Resource> getUnreadResource(ResourceResolver resolver, Constraint customConstraint, String channelId)
        throws RepositoryException;

}
