/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.notifications.channel;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

import javax.jcr.Session;

import com.adobe.cq.social.notifications.api.Notification;

public abstract class AbstractChannel<T extends ChannelExtension> implements Channel {
    protected SortedSet<T> extensionProviders = new TreeSet<T>(new Comparator<T>() {
        @Override
        public int compare(final T a, final T b) {
            return a.getOrder() - b.getOrder();
        }
    });

    protected Map<String, Object> configuration = new HashMap<String, Object>();

    public boolean accept(final String resourceType) {
        return true;
    }

    @Override
    public Map<String, Object> getConfiguration() {
        return configuration;
    }

    @SuppressWarnings("unchecked")
    protected synchronized void addChannelExtension(final T extension) {
        this.extensionProviders.add(extension);
    }

    @SuppressWarnings("unchecked")
    protected synchronized void removeChannelExtension(final T extension) {
        this.extensionProviders.remove(extension);
    }

    @Override
    public void performBeforeDeliver(final Notification notification, final String userId, final Session session,
        final Map<String, Object> configuration) throws ChannelException {
        for (final T extension : this.extensionProviders) {
            extension.beforeDeliver(notification, userId, session, configuration);
        }
    }

    @Override
    public void performAfterDeliver(final Notification notification, final String userId, final Session session,
        final Map<String, Object> configuration) throws ChannelException {
        for (final T extension : this.extensionProviders) {
            extension.afterDeliver(notification, userId, session, configuration);
        }
    }
}
