/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.notifications.channel;

import java.util.Map;

import javax.jcr.Session;

import com.adobe.cq.social.notifications.api.Notification;

public interface Channel {
    /**
     * Service registration property specifying the {@link getUserDescription} return value.
     * <p>
     * Channel service SHOULD be registered with this property. The value of the property is a string that describes
     * the functionality of the channel.
     */
    public static final String CHANNEL_DESCRIPTION = "channel.description";

    /**
     * The id of this channel
     * @return
     */
    String getId();

    /**
     * Check whether this channel to be executed immediately or not
     * @return
     */
    boolean isImmediate();

    /**
     * Get the description of this channel
     * @return
     */
    String getUserDescription();

    /**
     * Deliver the specified notification
     * @param notification
     * @param userId the user whom to be notified.
     */
    void deliver(final Notification notification, final String userId) throws ChannelException;

    /**
     * This method is being called before a channel performs its {@link Channel.deliver} operation. This is to allow
     * any channel extension to perform any delivery customization.
     * @param notification the target {@link Notification}
     * @param userId the user whom to be notified.
     * @param session the session that is being used to perform the operation.
     * @param configuration the channel configuration.
     * @throws ChannelException thrown if any one of the operations extensions throws an exception. This aborts the
     *             operations.
     */
    void performBeforeDeliver(Notification notification, final String userId, final Session session,
        final Map<String, Object> configuration) throws ChannelException;

    /**
     * This method is being called after a channel performs its {@link Channel.deliver} operation. This is to allow
     * any channel extension to perform any delivery customization.
     * @param notification the target {@link Notification}
     * @param userId the user whom to be notified.
     * @param session the session that is being used to perform the operation.
     * @param configuration the channel configuration.
     * @throws ChannelException thrown if any one of the operations extensions throws an exception. This aborts the
     *             operations.
     */
    void performAfterDeliver(Notification notification, final String userId, final Session session,
        final Map<String, Object> configuration) throws ChannelException;

    /**
     * Check whether the specified resource type is supported by this channel
     * @return
     */
    boolean accept(final String resourceType);

    /**
     * Get the channel configuration
     */
    Map<String, Object> getConfiguration();
}
