/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.notifications.channel;

import java.util.Map;

import javax.jcr.Session;

import com.adobe.cq.social.notifications.api.Notification;

public interface ChannelExtension {
    // Default extension order.
    int DEFAULT_ORDER = Integer.MAX_VALUE;
    // OSGi property name of the Extension order
    String PROP_EXTENSION_ORDER = "extension.order";

    /**
     * @return the extension calling order
     */
    int getOrder();

    /**
     * @return the name of the extension.
     */
    String getName();

    /**
     * Callback method before the {@link Channel.deliver(Notification)} is performed.
     * @param notification the target {@link Notification}
     * @param userId the user whom to be notified.
     * @param session the session used by the channel.
     * @param configuration the channel configuration.
     * @throws ChannelException thrown if any one of the extensions throw an exception. This aborts the channel
     *             delivery operations.
     */
    void beforeDeliver(final Notification notification, final String userId, final Session session,
        final Map<String, Object> configuration) throws ChannelException;

    /**
     * Callback method after the {@link Channel.deliver(Notification)} is performed.
     * @param notification the target {@link Notification}
     * @param userId the user whom to be notified.
     * @param session the session used by the channel.
     * @param configuration the channel configuration.
     * @throws ChannelException thrown if any one of the extensions throw an exception. This aborts the channel
     *             delivery operations.
     */
    void afterDeliver(final Notification notification, final String userId, final Session session,
        final Map<String, Object> configuration) throws ChannelException;
}
