/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.notifications.channel;

import java.util.List;

import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public interface ChannelManager {
    /**
     * Get the current available channels.
     * @return A list of the available channels
     */
    @Nonnull
    List<String> getAvailableChannels();

    /**
     * Gets a channel based on its ID.
     * @param channelId the string ID of the channel
     * @return a channel object
     */
    @CheckForNull
    Channel getChannel(final String channelId);

}
