/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.notifications.client.api;

import com.adobe.cq.social.scf.PageInfo;
import com.adobe.cq.social.scf.SocialCollectionComponent;

public interface SocialNotificationCollection extends SocialCollectionComponent {
    String PROP_USER_ID = "userId";
    String PROP_CHANNEL_ID = "channelId";
    String PROP_MAX_NOTIFICATIONS = "maxNotifications";

    String DEFAULT_CHANNEL_ID = "*"; // All channels
    String DEFAULT_MAX_NOTIFICATIONS = "-1";

    String RESOURCE_TYPE = "social/notifications/components/hbs/notifications";

    /**
     * Get the channel id of this collection
     * @return
     */
    String getChannelId();

    /**
     * Get the userId
     */
    String getUserId();

    /**
     * Get the number of unread notifications
     */
    long getUnreadCount();

    /**
     * Gets information about the pages for this collection. This can be used by the page block helper to easily
     * render various pagination UIs.
     * @return information about the pagination system
     */
    PageInfo getPageInfo();

}
