/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.notifications.endpoint;

import javax.annotation.Nonnull;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolverFactory;

import com.adobe.cq.social.scf.OperationException;
import com.adobe.cq.social.scf.SocialComponent;

public interface NotificationOperationService {

    /**
     * mark a notification status to be <code>Status.Read</code>
     * @param request the client request
     * @return the notification {@link SocialComponent}
     * @throws OperationException if there is an error occurs
     */
    SocialComponent markAsRead(@Nonnull final SlingHttpServletRequest request, ResourceResolverFactory factory)
        throws OperationException;

    SocialComponent markAllRead(@Nonnull final SlingHttpServletRequest request,
        @Nonnull ResourceResolverFactory factory) throws OperationException;
}
