/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.qna.client.api;

import java.util.Iterator;

import com.adobe.cq.social.forum.client.api.Post;
import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The simplysocial <code>QnaPost</code> interface specifies the contract for a qnaforum question.
 */
public interface QnaPost extends Post {

    /** The resource type. */
    String RESOURCE_TYPE = "social/qna/components/hbs/qnaforum";

    /** The resource type qna post (answer). */
    String RESOURCE_TYPE_POST = "social/qna/components/hbs/post";

    /** The resource type qna topic (question). */
    String RESOURCE_TYPE_TOPIC = "social/qna/components/hbs/topic";

    /** The answer postfix. */
    String POST_POSTFIX = "_tosp";

    /** The question postfix. */
    String TOPIC_POSTFIX = "_ciot";

    /** The answered tag. */
    String QNA_ANSWERED_TAG = "forum:topic/answered";

    /** The chosen answer tag. */
    String QNA_CHOSEN_ANSWER_TAG = "forum:topic/chosenanswer";

    /** The selected answers property name. */
    String PN_SELECTED_ANSWERS = "selectedAnswers";

    /** The move selected answer to top property name. */
    String QNA_MOVE_SELECTED_ANSWER_TO_TOP = "moveSelectedAnswerToTop";

    /**
     * Indicates whether this question is answered. If this is an answer, indicates whether the corresponding question
     * has been answered.
     * @return <code>true</code> if this question is answered.
     */
    @JsonProperty("isAnswered")
    boolean isAnswered();

    /**
     * Indicates whether this is chosen answer.
     * @return <code>true</code> if this is chosen answer.
     */
    @JsonProperty("isChosenAnswer")
    boolean isChosenAnswer();

    /**
     * Indicates whether this is chosen answer.
     * @return <code>true</code> if this is chosen answer.
     */
    @JsonProperty("canChooseAnswer")
    boolean canChooseAnswer();

    /**
     * Gets the list of answers in the property of the post resource.
     * @return an iterator for the paths that have been marked as an answer to this post
     */
    Iterator<String> getSelectedAnswers();

    String QNA_RESOURE_TYPE = "social/qna/components/hbs/relatedquestions";
}
