/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.qna.client.api;

import javax.jcr.RepositoryException;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.adobe.cq.social.commons.comments.listing.CommentSocialComponentListProviderManager;
import com.adobe.cq.social.qna.client.impl.QnaPostImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;

/**
 * A factory that will create instances of {@link QnaPost} given a {@link Resource} or {@link Resource} and
 * {@link SlingHttpServletRequest}.
 */
@Component
@Service
public class QnaPostSocialComponentFactory extends AbstractSocialComponentFactory implements SocialComponentFactory {
    /**
     * Logger for this class.
     */
    private static final Logger LOG = LoggerFactory.getLogger(QnaPostSocialComponentFactory.class);

    @Reference
    private CommentSocialComponentListProviderManager listProviderManager;

    @Override
    public SocialComponent getSocialComponent(final Resource resource) {
        return this.getSocialComponent(resource, null);
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final SlingHttpServletRequest request) {
        if (request == null) {
            return this.getSocialComponent(resource, getClientUtilities(resource.getResourceResolver()),
                getQueryRequestInfo(null));
        }
        return this.getSocialComponent(resource, getClientUtilities(request), getQueryRequestInfo(request));
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtilities,
        final QueryRequestInfo queryRequestInfo) {
        try {
            return new QnaPostImpl(resource, clientUtilities, queryRequestInfo, listProviderManager);
        } catch (final RepositoryException e) {
            getLogger().error("Failed to create QnA Post instance for %1", resource, e);
            return null;
        }
    }

    @Override
    public String getSupportedResourceType() {
        return QnaPost.RESOURCE_TYPE_POST;
    }

    /**
     * Get Logger for this class.
     * @return Logger for this class.
     */
    protected Logger getLogger() {
        return LOG;
    }
}
