/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.qna.client.api;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.qna.client.impl.QnaPostCollectionImpl;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.QueryRequestInfo;
import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.SocialComponentFactory;
import com.adobe.cq.social.scf.SocialComponentFactoryManager;
import com.adobe.cq.social.scf.core.AbstractSocialComponentFactory;
import com.adobe.cq.social.ugc.api.RelatedSearch;

/**
 * A factory that will create instances of {@link QnaPostCollection} given a {@link Resource} or {@link Resource} and
 * {@link SlingHttpServletRequest}.
 */
@Component
@Service
public class QnaRelatedComponentFactory extends AbstractSocialComponentFactory implements SocialComponentFactory {

    /**
     * Search engine using lucene.
     */
    @Reference
    private RelatedSearch relatedSearch;

    @Reference
    private SocialComponentFactoryManager socialComponentFactoryManager;

    @Override
    public SocialComponent getSocialComponent(final Resource resource) {
        return new QnaPostCollectionImpl(resource, getClientUtilities(resource.getResourceResolver()),
            QueryRequestInfo.DEFAULT_QUERY_INFO_FACTORY.create(), relatedSearch, socialComponentFactoryManager);
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final SlingHttpServletRequest request) {
        return new QnaPostCollectionImpl(resource, getClientUtilities(request), getQueryRequestInfo(request),
            relatedSearch, socialComponentFactoryManager);
    }

    @Override
    public SocialComponent getSocialComponent(final Resource resource, final ClientUtilities clientUtilities,
        final QueryRequestInfo queryRequestInfo) {
        return new QnaPostCollectionImpl(resource, clientUtilities, queryRequestInfo, relatedSearch,
            socialComponentFactoryManager);
    }

    @Override
    public String getSupportedResourceType() {
        return QnaPostCollection.RESOURCE_TYPE_RELATED_QUESTIONS;
    }
}
