/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.qna.client.endpoints;

import com.adobe.cq.social.qna.client.api.QnaPost;
import com.adobe.cq.social.scf.Operation;
import com.adobe.cq.social.scf.OperationExtension;

/**
 * Hook operation to enable clients register callback during an execution of an operation.
 */
public interface QnaForumOperationExtension extends OperationExtension<QnaPost> {
    /**
     * Operation types.
     */
    public enum QnaForumOperation implements Operation {
        /** Create Operation. */
        CREATE,
        /** Update operation. */
        UPDATE,
        /** Delete operation. */
        DELETE,
        /** Select answer operation. */
        ANSWER_SELECTED,
        /** Unselect answer operation. */
        ANSWER_UNSELECTED,
        // Image upload operation
        UPLOADIMAGE
    }
}
