/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 *
 *************************************************************************/
package com.adobe.cq.social.qna.client.endpoints;

import javax.jcr.Session;

import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.forum.client.endpoints.ForumOperations;
import com.adobe.cq.social.scf.OperationException;

/**
 * {@inheritDoc}.
 */
public interface QnaForumOperations extends ForumOperations {

    /**
     * Attempt to add a resource as the answer to the post.
     * @param request the client request
     * @param session the user session to be used to create the new comment
     * @return the new {@link com.adobe.cq.social.qna.client.api.QnaPost}
     * @throws OperationException if there is an error occurs
     */
    Resource selectAnswer(final SlingHttpServletRequest request, final Session session) throws OperationException;

    /**
     * Unselect this answer if it is the chosen answer. Replicate the change if replicator is not null. Delete the
     * answer if delete flag is true. If this is not an answer, do nothing.
     * @param request the client request
     * @param session the user session to be used to create the new comment
     * @return the new {@link com.adobe.cq.social.qna.client.api.QnaPost}
     * @throws OperationException if there is an error occurs
     */
    Resource unselectAnswer(final SlingHttpServletRequest request, final Session session) throws OperationException;
}
