/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2015 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.reporting.analytics.api;

import java.util.Calendar;

import com.adobe.cq.social.scf.SocialComponent;
import com.adobe.cq.social.scf.User;

public interface AnalyticsCommunityActivity extends SocialComponent {

    String RESOURCE_TYPE = "social/reporting/analytics/components/hbs/communityactivity";

    /**
     * Returns the relevant analytics metric count.
     * @return count
     */
    long getCount();

    /**
     * Returns the activity type (e.g users, content).
     * @return activity type
     */
    String getActivityType();

    /**
     * If this is content activity, returns the UGC type of the content.
     * @return UGC type
     */
    String getUgcType();

    /**
     * If this is content activity, returns the title of the UGC content.
     * @return title
     */
    String getTitle();

    /**
     * If this is content activity, returns the path of the UGC content.
     * @return path
     */
    String getPath();

    /**
     * If this is member activity, returns the user object containing user meta data (e.g. avatar url).
     * @return user
     */
    User getMember();

    /**
     * If this is content activity, returns the date the content was created.
     * @return
     */
    Calendar getCreated();
}
