/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.reporting.dv.api;

import java.util.ArrayList;
import java.util.List;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;

import com.adobe.cq.social.reporting.ReportingConstants;
import com.adobe.cq.social.reporting.dv.model.api.BarChartModel;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.core.BaseSocialComponent;

public class AbstractDVBarChartComponent extends BaseSocialComponent {

    protected BarChartModel responseObject;

    public AbstractDVBarChartComponent(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);

        responseObject = new BarChartModel(null, null);
    }

    protected void postProcessDV(JSONArray result, int maxSegments) throws JSONException {

        int totalCount = result.getJSONObject(maxSegments).getInt(ReportingConstants.REPORTING_COUNT);
        if (totalCount == 0) {
            // nothing to show
            return;
        }

        ArrayList<Long> values = new ArrayList<Long>();
        ArrayList<String> labels = new ArrayList<String>();

        for (int i = 0; i < maxSegments; i++) {
            values.add(result.getJSONObject(i).getLong(ReportingConstants.REPORTING_COUNT));
            labels.add(result.getJSONObject(i).getString(ReportingConstants.REPORTING_DESCRIPTION));
        }

        responseObject = new BarChartModel(values, labels);
    }

    @Override
    protected List<String> getIgnoredProperties() {
        this.ignoredProperties.add("jcr:.*");
        return this.ignoredProperties;
    }

    public BarChartModel getData() {
        return responseObject;
    }
}
