/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.reporting.dv.api;

import java.util.ArrayList;
import java.util.List;

import org.apache.sling.api.resource.Resource;
import org.apache.sling.commons.json.JSONArray;
import org.apache.sling.commons.json.JSONException;

import com.adobe.cq.social.reporting.ReportingConstants;
import com.adobe.cq.social.reporting.dv.model.api.DonutChartData;
import com.adobe.cq.social.reporting.dv.model.api.DonutChartLabels;
import com.adobe.cq.social.reporting.dv.model.api.DonutChartModel;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.core.BaseSocialComponent;

public abstract class AbstractDVDonutChartComponent extends BaseSocialComponent {

    protected DonutChartModel responseObject;

    protected AbstractDVDonutChartComponent(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);

        responseObject = new DonutChartModel(null, null);
    }

    protected void postProcessDV(JSONArray result, int maxSegments) throws JSONException {

        int totalCount = result.getJSONObject(maxSegments).getInt(ReportingConstants.REPORTING_COUNT);
        if (totalCount == 0) {
            // nothing to show
            return;
        }

        ArrayList<Long> x = new ArrayList<Long>();
        ArrayList<Long> y = new ArrayList<Long>();
        ArrayList<String> category1 = new ArrayList<String>();

        ArrayList<Long> x2 = new ArrayList<Long>();
        ArrayList<Long> y2 = new ArrayList<Long>();
        ArrayList<String> percentLabels = new ArrayList<String>();
        ArrayList<String> category2 = new ArrayList<String>();

        int percentSum = 100;
        long percent;

        for (int i = 0; i < maxSegments; i++) {
            int count = result.getJSONObject(i).getInt(ReportingConstants.REPORTING_COUNT);
            percent = Math.round(count * 100.0 / totalCount);

            x.add(Long.valueOf(1));
            if (count > 0) {
                category1.add(0, result.getJSONObject(i).getString(ReportingConstants.REPORTING_DESCRIPTION));
                category2.add(0, result.getJSONObject(i).getString(ReportingConstants.REPORTING_DESCRIPTION));
                y.add(0, Long.valueOf(count));

                x2.add(Long.valueOf(2));
                y2.add(0, percentSum - (percent / 2));
                percentLabels.add(0, percent + "%");
            } else {
                /*
                 * Elements with count=0 should go at the end of the list so that the color coordination between the
                 * legend and the chart matches correctly (color for count=0 elements shouldn't appear on chart)
                 * though it exists in the legend
                 */
                category1.add(result.getJSONObject(i).getString(ReportingConstants.REPORTING_DESCRIPTION));
                y.add(Long.valueOf(count));
            }

            percentSum -= percent;
        }

        DonutChartData dData = new DonutChartData(x, y, category1);
        DonutChartLabels dLabels = new DonutChartLabels(x2, y2, category2, percentLabels, totalCount);

        responseObject = new DonutChartModel(dData, dLabels);
    }

    public DonutChartData getData() {
        return responseObject == null ? null : responseObject.getData();
    }

    public DonutChartLabels getLabels() {
        return responseObject == null ? null : responseObject.getLabels();
    }

    @Override
    protected List<String> getIgnoredProperties() {
        this.ignoredProperties.add("jcr:.*");
        return this.ignoredProperties;
    }
}
