/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.reporting.dv.api;

import java.util.List;

import org.apache.sling.api.resource.Resource;

import com.adobe.cq.social.reporting.dv.model.api.LineChartModel;
import com.adobe.cq.social.scf.ClientUtilities;
import com.adobe.cq.social.scf.core.BaseSocialComponent;

public abstract class AbstractDVLineChartComponent extends BaseSocialComponent {

    protected LineChartModel responseObject;

    public AbstractDVLineChartComponent(Resource resource, ClientUtilities clientUtils) {
        super(resource, clientUtils);

        responseObject = new LineChartModel(null, null, null);
    }

    @Override
    protected List<String> getIgnoredProperties() {
        this.ignoredProperties.add("jcr:.*");
        return this.ignoredProperties;
    }

    public LineChartModel getData() {
        return responseObject;
    }

}
