/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.reporting.dv.model.api;

import java.util.List;

/**
 * BarChartModel is the top level object that encompasses the format of data that we will pass to a DV bar chart.
 */
public class BarChartModel {

    /**
     * Bar values for DV
     */
    private final List<Long> values;

    /**
     * Bar labels for DV
     */
    private final List<String> labels;

    public BarChartModel(List<Long> values, List<String> labels) {
        this.values = values;
        this.labels = labels;
    }

    public List<Long> getValues() {
        return values;
    }

    public List<String> getLabels() {
        return labels;
    }

}
