/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.reporting.dv.model.api;

import java.util.List;

/**
 * DonutChartData is a second level object within DonutChartModel that we will pass on to DV.
 */
public class DonutChartData {

    /**
     * specifies '1' for each segment to be represented in the chart
     */
    private final List<Long> x;

    /**
     * specifies the count for each segment in the chart
     */
    private final List<Long> y;

    /**
     * specifies the name of each segment in the chart
     */
    private final List<String> categories;

    public DonutChartData(List<Long> x, List<Long> y, List<String> categories) {
        this.x = x;
        this.y = y;
        this.categories = categories;
    }

    public List<Long> getX() {
        return x;
    }

    public List<Long> getY() {
        return y;
    }

    public List<String> getCategories() {
        return categories;
    }

}
