/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.reporting.dv.model.api;

import java.util.List;

/**
 * DonutChartLabels is a second level object within DonutChartModel that we will pass on to DV.
 */
public class DonutChartLabels {

    /**
     * specifies '2' for each segment to label
     */
    private final List<Long> x;

    /**
     * specifies the percent location (a value between 0-100) along the circle to draw the segment label
     */
    private final List<Long> y;

    /**
     * specifies the segment label
     */
    private final List<String> categories;

    /**
     * specifies the segment percentage
     */
    private final List<String> percentLabels;

    /**
     * specifies the total count to go in the center of the pie
     */
    private final long totalCount;

    public DonutChartLabels(List<Long> x, List<Long> y, List<String> categories, List<String> percentLabels,
        long totalCount) {
        this.x = x;
        this.y = y;
        this.categories = categories;
        this.percentLabels = percentLabels;
        this.totalCount = totalCount;
    }

    public List<Long> getX() {
        return x;
    }

    public List<Long> getY() {
        return y;
    }

    public List<String> getCategories() {
        return categories;
    }

    public List<String> getPercentLabels() {
        return percentLabels;
    }

    public long getTotalCount() {
        return totalCount;
    }
}
