/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.reporting.dv.model.api;

/**
 * DonutChartModel is the top level object that encompasses the format of data that we will pass to a DV donut chart.
 */
public class DonutChartModel {

    /**
     * encapsulates the data points for the donut chart
     */
    private final DonutChartData data;

    /**
     * encapsulates the label info for the donut chart
     */
    private final DonutChartLabels labels;

    public DonutChartModel(DonutChartData data, DonutChartLabels labels) {
        this.data = data == null ? new DonutChartData(null, null, null) : data;
        this.labels = labels == null ? new DonutChartLabels(null, null, null, null, -1) : labels;
    }

    public DonutChartData getData() {
        return data;
    }

    public DonutChartLabels getLabels() {
        return labels;
    }

}
