/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.reporting.dv.model.api;

import java.util.List;

/**
 * LineChartModel is the top level object that encompasses the format of data that we will pass to a DV line chart.
 */
public class LineChartModel {

    /**
     * x-axis data points for DV
     */
    private final List<String> x;

    /**
     * y-axis data points for DV
     */
    private final List<String> y;

    /**
     * name of the series that the given data point at the given index should be associated with, which corresponds
     * with the data point at same index of x and y above.
     */
    private final List<String> series;

    public LineChartModel(List<String> x, List<String> y, List<String> series) {
        this.x = x;
        this.y = y;
        this.series = series;
    }

    public List<String> getX() {
        return x;
    }

    public List<String> getY() {
        return y;
    }

    public List<String> getSeries() {
        return series;
    }
}
