/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.review.client.api;

import java.util.List;
import java.util.Map;

import javax.jcr.RepositoryException;

import com.adobe.cq.social.commons.comments.api.CommentCollection;
import com.adobe.cq.social.commons.comments.api.CommentCollectionConfiguration;
import com.adobe.cq.social.tally.client.api.ResponseValue;
import com.adobe.cq.social.tally.client.api.TallyException;
import com.adobe.cq.social.tally.client.api.RatingSocialComponent;

/**
 * Social Component for any Review resource.
 */
public interface ReviewCollectionSocialComponent<C extends ReviewSocialComponent, T extends CommentCollectionConfiguration>
    extends CommentCollection<C, T> {
    /**
     * @return The name of the review component.
     */
    String getName();

    /**
     * @return the total number of responses to this review.
     */
    Long getTotalNumberOfResponses();

    /**
     * @return a map of the current users response given a session.
     * @throws TallyException if there was an error retrieving the current users response.
     * @throws RepositoryException if there was an error retrieving the current users response.
     */
    Map<String, ResponseValue> getCurrentUserResponse() throws TallyException, RepositoryException;

    /**
     * @return a map of all rating titles to the RatingSocialComponent for this review.
     */
    Map<String, RatingSocialComponent> getRatings();

    /**
     * @return a RatingSocialComponent for overall rating.
     */
    RatingSocialComponent getOverallRating();

    /**
     * @return a map of all rating titles to rating averages for this review.
     */
    Map<String, String> getRatingAverages();

    /**
     * @return the list of allowed ratings' properties that are designed by the author.
     */
    List<Map<String, String>> getAllowedRatings();

    /**
     * Return true if the review has composite ratings.
     * @return true if the review has composite ratings.
     */
    boolean isCompositeRating();

    /**
     * Return true if the review summary includes histogram.
     * @return true if the review summary includes histogram.
     */
    boolean isIncludeHistogram();
}
