/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/

package com.adobe.cq.social.review.client.api;

/**
 * Holds string constants that are used across the Review API.
 */
public class ReviewConstants {
    /**
     * The resource type of all review system resources
     */
    public static final String REVIEWS_RESOURCE_TYPE = "social/reviews/components/hbs/reviews";
    /**
     * The resource type of review resources
     */
    public static final String REVIEW_RESOURCE_TYPE = "social/reviews/components/hbs/reviews/review";
    /**
     * The resource type of review summary resources
     */
    public static final String REVIEW_SUMMARY_RESOURCE_TYPE = "social/reviews/components/hbs/summary";
    /**
     * Name of the JCR property that stores the review name.
     */
    public static final String NAME_PROPERTY = "name";
    /**
     * Name of the JCR property that stores the rating response paths.
     */
    public static final String RATINGS_PROPERTY = "ratings";
    /**
     * Name of the JCR property that stores the allowed sub ratings.
     */
    public static final String ALLOWED_RATINGS_PROPERTY = "allowedRatings";
    /**
     * Name of the JCR property that stores the required sub ratings.
     */
    public static final String REQUIRED_RATINGS_PROPERTY = "requiredRatings";
    /**
     * Name of the JCR property that includes histogram in summary.
     */
    public static final String INCLUDE_HISTOGRAM_PROPERTY = "includeHistogram";
    /**
     * Name of the JCR property that stores review path.
     */
    public static final String REVIEW_PATH_PROPERTY = "reviewPath";
    /**
     * The default response URL that handles all review user responses.
     */
    public static final String DEFAULT_RESPONSE_URL_SELECTOR = ".social.setreviewresponse.html";
    /**
     * The default path for overall rating.
     */
    public static final String PATH_OVERALL_RATING = "Overall";
    /**
     * The default path for voting.
     */
    public static final String PATH_VOTING = "voting";
    /**
     * The key for comment in the customer response map
     */
    public static final String KEY_COMMENT = "comment";

}
