/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2013 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.cq.social.review.client.api;

import java.io.Serializable;
import java.util.HashMap;

import com.adobe.cq.social.review.client.api.ReviewEvent.Type;
import com.adobe.cq.social.scf.core.SocialEvent;
import com.adobe.granite.activitystreams.ObjectTypes;
import com.adobe.granite.activitystreams.Verbs;

/**
 * Event fired for changes occurring within a review system.
 */
public class ReviewEvent extends SocialEvent<Type> implements Serializable {

    /** A serialVersionUID for this class. */
    private static final long serialVersionUID = 2L;

    /**
     * The event topic suffix for review events
     */
    public static final String REVIEW_TOPIC = SocialEvent.SOCIAL_EVENT_TOPIC_PREFIX + "review";
    protected static final String REVIEW_SYSTEM_PATH = "REVIEW_SYSTEM_PATH";

    /**
     * The event types supported for the forum and its topics/posts.
     */
    public static enum Type implements SocialEvent.SocialActions {

        /**
         * The event fired upon a review being added.
         */
        ReviewAdded,

        /**
         * The event fired upon approval of a moderated review.
         * @deprecated has never (and will never) be thrown.
         */
        @Deprecated
        ReviewApproved,

        ReviewEdited,

        ReviewDeleted;

        @Override
        public String getVerb() {
            switch (this) {
                case ReviewAdded:
                    return Verbs.POST;
                case ReviewApproved: // Deprecated
                    return Verbs.APPROVE;
                case ReviewEdited:
                    return Verbs.UPDATE;
                case ReviewDeleted:
                    return Verbs.DELETE;
                default:
                    return Verbs.POST;
            }
        }

    }

    public ReviewEvent(final ReviewSocialComponent review, final String userId, final Type type) {
        super(REVIEW_TOPIC, review.getResource().getPath(), userId, type, new BaseEventObject("a review", review
            .getResource().getPath(), ObjectTypes.REVIEW), new BaseEventObject((review.getSourceComponent() != null)
            ? review.getSourceComponent().getResource().getPath() : review.getSourceComponentId(),
            ObjectTypes.ARTICLE), new HashMap<String, Object>(0));
    }

}
